<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Api\OrderSync;

/**
 * SaaS order sync REST API.
 *
 * @api
 */
interface OrderSyncManagerInterface
{
    /**
     * POST create an order synchronization
     *
     * @param string $client_code who created the sync
     * @param string $created_from initial created_at date to sync in ISO8601 format
     * @param string $created_to non-inclusive end created_at date to sync in ISO8601 format. Optional argument that defaults to 'now' if it is not provided
     * @return \Magento\SaaSOrderSync\Api\OrderSync\CreateOrderSyncResponseInterface the order synchronization result
     */
    public function createOrderSync(
        string $client_code,
        string $created_from,
        string $created_to = 'now'
    ): CreateOrderSyncResponseInterface;

    /**
     * GET all order synchronizations
     *
     * @return \Magento\SaaSOrderSync\Api\OrderSync\GetAllOrderSyncsResponseInterface the order synchronizations
     */
    public function getAllOrderSyncs(): GetAllOrderSyncsResponseInterface;

    /**
     * GET one order synchronization by its identifier
     *
     * @param string $sync_id synchronization id
     * @return \Magento\SaaSOrderSync\Api\OrderSync\GetOneOrderSyncResponseInterface the order synchronization
     */
    public function getOneOrderSync(string $sync_id): GetOneOrderSyncResponseInterface;

    /**
     * PUT cancel an order synchronization
     *
     * @param string $sync_id synchronization id
     * @return \Magento\SaaSOrderSync\Api\OrderSync\CancelOrderSyncResponseInterface the cancellation result
     */
    public function cancelOrderSync(string $sync_id): CancelOrderSyncResponseInterface;
}
