<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Event;

use Magento\Framework\App\ResourceConnection;

class OrderRepository
{
    private ResourceConnection $resourceConnection;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    public function findOrderUuid($order_entity_id): ?string
    {
        $connection = $this->resourceConnection->getConnection();

        $selectUuid = $connection->select()
            ->from(
                $this->dataExporterUuidTable(),
                ['uuid'],
            )
            ->where('type = ? ', 'order')
            ->where('entity_id = ? ', $order_entity_id);

        $row = $connection->fetchRow($selectUuid) ?? [];
        return $row['uuid'];
    }

    private function dataExporterUuidTable(): string
    {
        return $this->resourceConnection->getTableName('data_exporter_uuid');
    }
}
