<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Core\SaaS;

use Magento\SaaSOrderSync\Core\OrderSync\SaaSClient as OrderSyncSaaSClient;
use Magento\ServicesConnector\Api\ClientResolverInterface;

class SaaSClientResolver implements SaaSClientResolverInterface
{
    private ClientResolverInterface $clientResolver;
    private SaaSConfig $saaSConfig;

    public function __construct(ClientResolverInterface $clientResolver, SaaSConfig $saaSConfig)
    {
        $this->clientResolver = $clientResolver;
        $this->saaSConfig = $saaSConfig;
    }

    public function createOrderSyncClient(): OrderSyncSaaSClient
    {
        $syncUrl = $this->saaSConfig->getOrderServiceSyncUrl();
        return new OrderSyncSaaSClient($this->create(), $syncUrl);
    }

    private function create(): SaaSClient
    {
        $environmentId = $this->saaSConfig->getEnvironmentId();
        $client = $this->clientResolver->createHttpClient(
            'Magento_SaaSOrderSync',
            $this->saaSConfig->getEnvironment()
        );
        return new SaaSClient($environmentId, $client);
    }
}
