<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Test\Unit\Core\SaaS;

use Magento\SaaSOrderSync\Core\Merchant\MerchantSaaSClient;
use Magento\SaaSOrderSync\Core\OrderSync\SaaSClient;
use Magento\SaaSOrderSync\Core\SaaS\SaaSClientResolverInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class SaaSClientMockResolver implements SaaSClientResolverInterface
{

    private SaaSClient&MockObject $orderSyncSaaSClient;
    private MerchantSaaSClient&MockObject $merchantSaaSClient;

    private TestCase $testCase;

    public function __construct(TestCase $testCase)
    {
        $this->testCase = $testCase;
    }

    public function createOrderSyncClient(): SaaSClient&MockObject
    {
        if (!isset($this->orderSyncSaaSClient)) {
            $this->orderSyncSaaSClient = $this->createMockObject(SaaSClient::class);
        }
        return $this->orderSyncSaaSClient;
    }

    public function createMerchantClient(): MerchantSaaSClient&MockObject
    {
        if (!isset($this->merchantSaaSClient)) {
            $this->merchantSaaSClient = $this->createMockObject(MerchantSaaSClient::class);
        }
        return $this->merchantSaaSClient;
    }

    /**
     * Copied from PHPUnit's TestCase
     * @see TestCase::createMockObject()
     *
     * @psalm-template RealInstanceType of object
     * @psalm-param class-string<RealInstanceType> $originalClassName
     * @psalm-return MockObject&RealInstanceType
     */
    private function createMockObject(string $originalClassName): MockObject
    {
        return $this->testCase->getMockBuilder($originalClassName)
            ->disableOriginalConstructor()
            ->disableOriginalClone()
            ->disableArgumentCloning()
            ->disallowMockingUnknownTypes()
            ->getMock();
    }
}
