<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Core\SaaS;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\ServicesId\Model\MerchantRegistryProvider;
use Magento\ServicesId\Model\ServicesConfigInterface;
use RuntimeException;

class SaaSConfig
{
    private ScopeConfigInterface $scopeConfig;
    private ServicesConfigInterface $servicesConfig;
    private MerchantRegistryProvider $merchantRegistryProvider;

    public function __construct(
        ScopeConfigInterface     $scopeConfig,
        ServicesConfigInterface  $servicesConfig,
        MerchantRegistryProvider $merchantRegistryProvider
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->servicesConfig = $servicesConfig;
        $this->merchantRegistryProvider = $merchantRegistryProvider;
    }

    public function getEnvironment(): string
    {
        return $this->scopeConfig->getValue('magento_saas/environment');
    }

    public function getOrderServiceSyncUrl(): string
    {
        return $this->scopeConfig->getValue('magento_saas/routes/orders/sync');
    }

    public function getOrderServiceMerchantUrl(): string
    {
        return $this->scopeConfig->getValue('magento_saas/routes/orders/merchant');
    }

    public function getEnvironmentId(): string
    {
        return $this->servicesConfig->getEnvironmentId();
    }

    public function getMageId(): string
    {
        $allEnvironments = $this->merchantRegistryProvider->getMerchantRegistry();
        if (empty($allEnvironments)) {
            throw new RuntimeException("Can't find environments in merchant registry, check services-id configuration.");
        }

        $environmentId = $this->getEnvironmentId();
        $environments = array_values(
            array_filter($allEnvironments, fn (array $env): bool => $env['environmentId'] == $environmentId)
        );

        if (empty($environments)) {
            $otherEnvironments = json_encode(array_map(fn (array $env): string => $env['environmentId'], $allEnvironments));
            throw new RuntimeException("Can't find environment '$environmentId' in the provided environments, other environments are $otherEnvironments");
        }

        [$environment] = $environments;
        return $environment['mageId'];
    }
}
