<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\Merchant;

use Magento\SaaSOrderSync\Core\SaaS\SaaSClient;
use Psr\Http\Message\ResponseInterface;
use RuntimeException;

class MerchantSaaSClient
{

    private SaaSClient $client;
    private string $merchantUrl;

    public function __construct(SaaSClient $client, string $merchantUrl)
    {
        $this->client = $client;
        $this->merchantUrl = $merchantUrl;
    }

    public function getDataSummary(): array
    {
        $args = get_defined_vars();

        $res = $this->client->request('GET', "$this->merchantUrl/dataSummary");
        $statusCode = $res->getStatusCode();

        if ($statusCode >= 200 && $statusCode <= 299) {
            return json_decode($res->getBody()->getContents(), true);
        }

        $this->throwException(__METHOD__, $args, $res);
    }

    private function throwException(string $method, array $args, ResponseInterface $response)
    {
        $ctx = json_encode([
            'args' => $args,
            'response' => [
                'statusCode' => $response->getStatusCode(),
                'body' => $response->getBody()->getContents(),
            ]
        ]);
        throw new RuntimeException("Unexpected error on $method. ctx=$ctx");
    }
}
