<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Api\Merchant;

interface MerchantDataSummaryOrdersInterface
{
    /**
     * @return string the created-from timestamp
     */
    public function getCreatedFrom(): string;

    /**
     * @return string the created-to timestamp
     */
    public function getCreatedTo(): string;

    /**
     * @return int the total number of orders between the createdFrom and the createdTo
     */
    public function getTotalCount(): int;

    /**
     * @return int the number of errors that happened while executing the order synchronization
     */
    public function getSyncErrorsCount(): int;
}
