<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Test\Unit\Core\OrderSync;

use Magento\AsynchronousOperations\Api\Data\OperationInterface;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationCancelationPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationCompletionPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationConsumer;

/**
 * Runner for running OrdersBulkConsumer and its plugins.
 *
 * @see https://developer.adobe.com/commerce/php/development/components/plugins/#prioritizing-plugins
 */
class OrdersBulkConsumerWithPluginsRunner
{
    private OperationConsumer $consumer;
    private OperationCancelationPlugin $cancelationPlugin;
    private OperationCompletionPlugin $completionPlugin;

    public function __construct(
        OperationConsumer          $consumer,
        OperationCancelationPlugin $cancelationPlugin,
        OperationCompletionPlugin  $completionPlugin
    ) {
        $this->consumer = $consumer;
        $this->cancelationPlugin = $cancelationPlugin;
        $this->completionPlugin = $completionPlugin;
    }

    public function consume(OperationInterface $operation): bool
    {
        $wrappedConsume = function ($op) {
            $result =  $this->consumer->consume($op);
            return  $this->completionPlugin->afterConsume($this->consumer, $result, $op);
        };

        return $this->cancelationPlugin->aroundConsume($this->consumer, $wrappedConsume, $operation);
    }
}
