<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\SaaS;

use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use RuntimeException;
use Throwable;

class SaaSClient
{
    private string $environmentId;
    private Client $client;

    public function __construct(string $environmentId, Client $client)
    {
        $this->environmentId = $environmentId;
        $this->client = $client;
    }

    public function request(string $method, string $url, array $options = []): ResponseInterface
    {
        $options['headers'] = [
            'Magento-Environment-Id' => $this->environmentId,
        ];
        //        $options['debug'] = true;

        try {
            return $this->client->request($method, $url, $options);
        } catch (Throwable $e) {
            $context = json_encode([
                'request' => ['method' => $method, 'url' => $url, 'options' => $options]
            ]);
            throw new RuntimeException("Http call failed. context=$context", 0, $e);
        }
    }
}
