<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\OrderSync;

use DateTime;
use DateTimeInterface;
use Magento\Framework\App\ResourceConnection;

class LocalOrderSyncRepository
{
    const TABLE_NAME = 'saas_order_sync';

    private ResourceConnection $resourceConnection;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    public function find(string $syncId): ?LocalOrderSync
    {
        $tableName = $this->resourceConnection->getTableName(self::TABLE_NAME);
        $connection = $this->resourceConnection->getConnection();

        $select = $connection->select()
            ->from($tableName)
            ->where('sync_id = ?', $syncId);

        $row = $connection->fetchRow($select);
        if ($row && $row['sync_id']) {
            $canceledAt = null;
            if ($row['canceled_at']) {
                $canceledAt = new DateTime($row['canceled_at']);
            }
            return new LocalOrderSync($row['sync_id'], $canceledAt);
        }

        return null;
    }

    public function upsert(string $syncId, DateTime $canceledAt): int
    {
        $tableName = $this->resourceConnection->getTableName(self::TABLE_NAME);
        $connection = $this->resourceConnection->getConnection();

        return $connection->insertOnDuplicate(
            $tableName,
            ['sync_id' => $syncId, 'canceled_at' => $canceledAt->format(DateTimeInterface::ATOM)],
            ['canceled_at']
        );
    }
}
