<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\OrderSync\Bulk;

use Magento\AsynchronousOperations\Api\Data\OperationInterface;
use Magento\SaaSOrderSync\Core\Bulk\BulkAdapter;
use Magento\SaaSOrderSync\Core\OrderSync\LocalOrderSyncRepository;
use Psr\Log\LoggerInterface;

class OperationCancelationPlugin
{
    private LoggerInterface $logger;
    private LocalOrderSyncRepository $localOrderSyncRepository;
    private BulkAdapter $bulkAdapter;

    public function __construct(
        LoggerInterface          $logger,
        LocalOrderSyncRepository $localOrderSyncRepository,
        BulkAdapter              $bulkAdapter
    ) {
        $this->logger = $logger;
        $this->localOrderSyncRepository = $localOrderSyncRepository;
        $this->bulkAdapter = $bulkAdapter;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function aroundConsume($_, callable $proceed, OperationInterface $operation): bool
    {
        $syncId = $operation->getBulkUuid();
        $operationId = $operation->getId();
        $ctx = ['syncId' => $syncId, 'operationId' => $operationId];

        $localOrderSync = $this->localOrderSyncRepository->find($syncId);
        if ($localOrderSync && $localOrderSync->isCanceled()) {
            $this->bulkAdapter->cancelOperation($operation);
            $this->logger->debug('Skipped operation since order sync is canceled.', $ctx);

            return false;
        }

        $this->logger->debug('Order sync is not canceled, proceeding with the execution of the operation.', $ctx);
        return $proceed($operation);
    }
}
