<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\Merchant;

use Magento\SaaSOrderSync\Api\Merchant\MerchantDataSummaryOrdersInterface;

class MerchantDataSummaryOrders implements MerchantDataSummaryOrdersInterface
{

    private string $createdFrom;
    private string $createdTo;
    private int $totalCount;
    private int $syncErrorsCount;

    public function __construct(string $createdFrom, string $createdTo, int $totalCount, int $syncErrorsCount)
    {
        $this->createdFrom = $createdFrom;
        $this->createdTo = $createdTo;
        $this->totalCount = $totalCount;
        $this->syncErrorsCount = $syncErrorsCount;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedFrom(): string
    {
        return $this->createdFrom;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedTo(): string
    {
        return $this->createdTo;
    }

    /**
     * @inheritdoc
     */
    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    /**
     * @inheritdoc
     */
    public function getSyncErrorsCount(): int
    {
        return $this->syncErrorsCount;
    }
}
