<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Core\OrderSync;

use Magento\SaaSOrderSync\Api\OrderSync\OrderSyncInterface;

class OrderSync implements OrderSyncInterface
{
    private string $syncId;
    private string $createdFrom;
    private string $createdTo;
    private string $clientCode;
    private int $initialCount;
    private int $processedCount;
    private int $errorCount;
    private string $status;

    public function __construct(
        string $syncId,
        string $createdFrom,
        string $createdTo,
        string $clientCode,
        int    $initialCount,
        int    $processedCount,
        int    $errorCount,
        string $status
    ) {
        $this->syncId = $syncId;
        $this->createdFrom = $createdFrom;
        $this->createdTo = $createdTo;
        $this->clientCode = $clientCode;
        $this->initialCount = $initialCount;
        $this->processedCount = $processedCount;
        $this->errorCount = $errorCount;
        $this->status = $status;
    }

    /**
     * @inheritdoc
     */
    public function getSyncId(): string
    {
        return $this->syncId;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedFrom(): string
    {
        return $this->createdFrom;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedTo(): string
    {
        return $this->createdTo;
    }

    /**
     * @inheritdoc
     */
    public function getClientCode(): string
    {
        return $this->clientCode;
    }

    /**
     * @inheritdoc
     */
    public function getInitialCount(): int
    {
        return $this->initialCount;
    }

    /**
     * @inheritdoc
     */
    public function getProcessedCount(): int
    {
        return $this->processedCount;
    }

    /**
     * @inheritdoc
     */
    public function getErrorCount(): int
    {
        return $this->errorCount;
    }

    /**
     * @inheritdoc
     */
    public function getStatus(): string
    {
        return $this->status;
    }
}
