<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSOrderSync\Api\OrderSync\Bulk;

use Magento\Framework\Mail\Exception\InvalidArgumentException;

/**
 * Pool for registering OperationProcessor instances using di.
 */
class OperationProcessorPool
{
    private array $operationProcessors;

    public function __construct(array $operationProcessors = [])
    {
        $this->allImplementingOperationProcessor($operationProcessors);
        usort($operationProcessors, fn ($p1, $p2): int => intval($p1->order() - $p2->order()));
        $this->operationProcessors = $operationProcessors;
    }

    public function get(): array
    {
        return $this->operationProcessors;
    }

    private function allImplementingOperationProcessor(array $objects): void
    {
        foreach ($objects as $object) {
            if (!($object instanceof OperationProcessor)) {
                $currentClass = get_class($object);
                $expectedInterface = OperationProcessor::class;
                throw new InvalidArgumentException("\"$currentClass\" is not implementing \"$expectedInterface\".");
            }
        }
    }
}
