<?php
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Test\Unit\Core\SaaS;

use Magento\SaaSOrderSync\Core\Merchant\MerchantSaaSClient;
use Magento\SaaSOrderSync\Core\OrderSync\SaaSClient;
use Magento\SaaSOrderSync\Core\SaaS\SaaSClientResolverInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class SaaSClientMockResolver implements SaaSClientResolverInterface
{

    private SaaSClient&MockObject $orderSyncSaaSClient;
    private MerchantSaaSClient&MockObject $merchantSaaSClient;

    private TestCase $testCase;

    public function __construct(TestCase $testCase)
    {
        $this->testCase = $testCase;
    }

    public function createOrderSyncClient(): SaaSClient&MockObject
    {
        if (!isset($this->orderSyncSaaSClient)) {
            $this->orderSyncSaaSClient = $this->createMockObject(SaaSClient::class);
        }
        return $this->orderSyncSaaSClient;
    }

    public function createMerchantClient(): MerchantSaaSClient&MockObject
    {
        if (!isset($this->merchantSaaSClient)) {
            $this->merchantSaaSClient = $this->createMockObject(MerchantSaaSClient::class);
        }
        return $this->merchantSaaSClient;
    }

    /**
     * Copied from PHPUnit's TestCase
     * @see TestCase::createMockObject()
     *
     * @psalm-template RealInstanceType of object
     * @psalm-param class-string<RealInstanceType> $originalClassName
     * @psalm-return MockObject&RealInstanceType
     */
    private function createMockObject(string $originalClassName): MockObject
    {
        return $this->testCase->getMockBuilder($originalClassName)
            ->disableOriginalConstructor()
            ->disableOriginalClone()
            ->disableArgumentCloning()
            ->disallowMockingUnknownTypes()
            ->getMock();
    }
}
