<?php

namespace Magento\SaaSOrderSync\Api\OrderSync;

interface OrderSyncInterface
{

    /**
     * @return string the synchronization id
     */
    public function getSyncId(): string;

    /**
     * @return string the 'from' date time in ISO8601 format used to filter orders by creation time
     */
    public function getCreatedFrom(): string;

    /**
     * @return string the 'to' date time in ISO8601 format used to filter orders by creation time
     */
    public function getCreatedTo(): string;

    /**
     * @return string the client who triggered the order sync
     */
    public function getClientCode(): string;

    /**
     * @return int the initial amount of orders estimated to be synchronized
     */
    public function getInitialCount(): int;

    /**
     * @return int the amount of orders processed at the current time (including errors)
     */
    public function getProcessedCount(): int;

    /**
     * @return int the amount of orders which failed to process
     */
    public function getErrorCount(): int;

    /**
     * @return string the status of the synchronization
     */
    public function getStatus(): string;
}
