<?php

namespace Magento\SaaSOrderSync\Test\Unit\Core\OrderSync;

use Magento\Framework\DataObject\IdentityGeneratorInterface;

/**
 * @SuppressWarnings(PHPMD.UnusedFormalParameter)
 */
class FixedIdentityGenerator implements IdentityGeneratorInterface
{
    private string $id;

    public function __construct(string $id = null)
    {
        $this->setId($id ?: uniqid());
    }

    public function generateId(): string
    {
        return $this->id;
    }

    public function generateIdForData($data): string
    {
        return $this->id;
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function setId($id): void
    {
        $this->id = $id;
    }
}
