<?php

namespace Magento\SaaSOrderSync\Api\OrderSync\Bulk;

use Magento\SaaSOrderSync\Api\Result;

/**
 * Allows extending bulk operation processing from external modules.
 */
interface OperationProcessor
{
    const HIGHEST_PRECEDENCE = 0;
    const LOWEST_PRECEDENCE = PHP_INT_MAX;

    /**
     * Process the bulk operation. Note the result will be persisted within the bulk operation.
     * @param string $syncId the order sync identifier
     * @param OperationData $operationData the data of the bulk operation
     * @return Result of the processing
     */
    public function process(string $syncId, OperationData $operationData): Result;


    /**
     * Execution order of the processor, lower value means highest precedence.
     * @return int order of the processor
     * @see OperationProcessor::HIGHEST_PRECEDENCE
     * @see OperationProcessor::LOWEST_PRECEDENCE
     */
    public function order(): int;
}
