<?php

namespace Magento\SaaSOrderSync\Api\Merchant;

interface MerchantDataSummaryOrdersInterface
{
    /**
     * @return string the created-from timestamp
     */
    public function getCreatedFrom(): string;

    /**
     * @return string the created-to timestamp
     */
    public function getCreatedTo(): string;

    /**
     * @return int the total number of orders between the createdFrom and the createdTo
     */
    public function getTotalCount(): int;

    /**
     * @return int the number of errors that happened while executing the order synchronization
     */
    public function getSyncErrorsCount(): int;
}
