<?php

namespace Magento\SaaSOrderSync\Test\Unit\Core\OrderSync;

use Magento\AsynchronousOperations\Api\Data\OperationInterface;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationCancelationPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationCompletionPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\Bulk\OperationConsumer;

/**
 * Runner for running OrdersBulkConsumer and its plugins.
 *
 * @see https://developer.adobe.com/commerce/php/development/components/plugins/#prioritizing-plugins
 */
class OrdersBulkConsumerWithPluginsRunner
{
    private OperationConsumer $consumer;
    private OperationCancelationPlugin $cancelationPlugin;
    private OperationCompletionPlugin $completionPlugin;

    public function __construct(
        OperationConsumer          $consumer,
        OperationCancelationPlugin $cancelationPlugin,
        OperationCompletionPlugin  $completionPlugin
    ) {
        $this->consumer = $consumer;
        $this->cancelationPlugin = $cancelationPlugin;
        $this->completionPlugin = $completionPlugin;
    }

    public function consume(OperationInterface $operation): bool
    {
        $wrappedConsume = function ($op) {
            $result =  $this->consumer->consume($op);
            return  $this->completionPlugin->afterConsume($this->consumer, $result, $op);
        };

        return $this->cancelationPlugin->aroundConsume($this->consumer, $wrappedConsume, $operation);
    }
}
