<?php
declare(strict_types=1);

namespace Magento\SaaSOrderSync\Core\OrderSync;

use Magento\Framework\App\Config\ScopeConfigInterface;

class Config
{
    private ScopeConfigInterface $scopeConfig;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function getNumberOfAggregatesInOperation(): int {
        return intval($this->scopeConfig->getValue('saas_order_sync/operation/number_of_aggregates'));
    }
}
