<?php

namespace Magento\SaaSOrderSync\Core\Eventing;

use Magento\AdobeCommerceEventsClient\Event\Metadata\EventMetadataInterface;
use Magento\ServicesId\Model\ServicesConfigInterface;

/**
 * Injects services-id metadata into the event until the saas pipeline is used
 */
class SaaSMetadata implements EventMetadataInterface
{

    private ServicesConfigInterface $servicesConfig;

    public function __construct(ServicesConfigInterface $servicesConfig)
    {
        $this->servicesConfig = $servicesConfig;
    }

    public function get(): array
    {
        return [
            'saas' => [
                'environmentId' => $this->servicesConfig->getEnvironmentId(),
                'projectId' => $this->servicesConfig->getProjectId(),
                'cloudId' => $this->servicesConfig->getCloudId(),
                'imsOrgId' => $this->servicesConfig->getImsOrganizationId(),
            ]
        ];
    }
}
