<?php

namespace Magento\SaaSOrderSync\Test\Unit\Core\Common\Time;

use DateTime;
use Magento\SaaSOrderSync\Core\Common\Time\ClockInterface;

class ClockMock implements ClockInterface
{
    private DateTime $now;

    public function __construct(string $now = 'now')
    {
        $this->setNow($now);
    }

    public function now(): DateTime
    {
        return $this->now;
    }

    public function setNow(string $now): void
    {
        $this->now = new DateTime($now);
    }
}
