<?php

declare(strict_types=1);

namespace Magento\SaaSOrderSync\Core\SaaS;

use Magento\SaaSOrderSync\Core\Merchant\MerchantSaaSClient;
use Magento\SaaSOrderSync\Core\OrderSync\SaaSClient as OrderSyncSaaSClient;
use Magento\ServicesConnector\Api\ClientResolverInterface;

class SaaSClientResolver implements SaaSClientResolverInterface
{
    private ClientResolverInterface $clientResolver;
    private SaaSConfig $saaSConfig;

    public function __construct(ClientResolverInterface $clientResolver, SaaSConfig $saaSConfig)
    {
        $this->clientResolver = $clientResolver;
        $this->saaSConfig = $saaSConfig;
    }

    public function createOrderSyncClient(): OrderSyncSaaSClient
    {
        $syncUrl = $this->saaSConfig->getOrderServiceSyncUrl();
        return new OrderSyncSaaSClient($this->create(), $syncUrl);
    }

    public function createMerchantClient(): MerchantSaaSClient
    {
        $merchantUrl = $this->saaSConfig->getOrderServiceMerchantUrl();
        return new MerchantSaaSClient($this->create(), $merchantUrl);
    }

    private function create(): SaaSClient
    {
        $environmentId = $this->saaSConfig->getEnvironmentId();
        $client = $this->clientResolver->createHttpClient(
            'Magento_SaaSOrderSync',
            $this->saaSConfig->getEnvironment()
        );
        return new SaaSClient($environmentId, $client);
    }
}
