<?php

namespace Magento\SaaSOrderSync\Core\SaaS;

use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use RuntimeException;
use Throwable;

class SaaSClient
{
    private string $environmentId;
    private Client $client;

    public function __construct(string $environmentId, Client $client)
    {
        $this->environmentId = $environmentId;
        $this->client = $client;
    }

    public function request(string $method, string $url, array $options = []): ResponseInterface
    {
        $options['headers'] = [
            'Magento-Environment-Id' => $this->environmentId,
        ];
//        $options['debug'] = true;

        try {
            return $this->client->request($method, $url, $options);
        } catch (Throwable $e) {
            $context = json_encode([
                'request' => ['method' => $method, 'url' => $url, 'options' => $options]
            ]);
            throw new RuntimeException("Http call failed. context=$context", 0, $e);
        }
    }
}
