<?php

namespace Magento\SaaSOrderSync\Core\OrderSync\Bulk;

use Magento\SaaSOrderSync\Api\OrderSync\Bulk\OperationData;
use Magento\SaaSOrderSync\Api\OrderSync\Bulk\OperationProcessor;
use Magento\SaaSOrderSync\Api\Result;
use Magento\SaaSOrderSync\Core\CommerceDataExport\OrdersDataExporterAdapter;
use Magento\SaaSOrderSync\Core\SaaS\SaaSClientResolverInterface;

class SyncOrderAggregatesOperationProcessor implements OperationProcessor
{

    private OrdersDataExporterAdapter $ordersExporterAdapter;
    private SaaSClientResolverInterface $clientResolver;

    public function __construct(OrdersDataExporterAdapter $ordersExporterAdapter, SaaSClientResolverInterface $clientResolver)
    {
        $this->ordersExporterAdapter = $ordersExporterAdapter;
        $this->clientResolver = $clientResolver;
    }


    public function process(string $syncId, OperationData $operationData): Result
    {
        return Result::wrap(function () use ($syncId, $operationData) {
            $orderIds = $operationData->getOrderIds();
            $this->ordersExporterAdapter->assignUuidsToOrderEntities($orderIds);
            $orders = $this->ordersExporterAdapter->exportCommerceOrderAggregates($orderIds);
            $syncClient = $this->clientResolver->createOrderSyncClient();

            return $syncClient->syncOrderBatch($syncId, $orders);
        });
    }

    public function order(): int
    {
        return OperationProcessor::HIGHEST_PRECEDENCE;
    }
}
