<?php

namespace Magento\SaaSOrderSync\Core\Merchant;

use Magento\SaaSOrderSync\Core\SaaS\SaaSClient;
use Psr\Http\Message\ResponseInterface;
use RuntimeException;

class MerchantSaaSClient
{

    private SaaSClient $client;
    private string $merchantUrl;

    public function __construct(SaaSClient $client, string $merchantUrl)
    {
        $this->client = $client;
        $this->merchantUrl = $merchantUrl;
    }

    public function getDataSummary(): array
    {
        $args = get_defined_vars();

        $res = $this->client->request('GET', "$this->merchantUrl/dataSummary");
        $statusCode = $res->getStatusCode();

        if ($statusCode >= 200 && $statusCode <= 299) {
            return json_decode($res->getBody()->getContents(), true);
        }

        $this->throwException(__METHOD__, $args, $res);
    }

    private function throwException(string $method, array $args, ResponseInterface $response)
    {
        $ctx = json_encode([
            'args' => $args,
            'response' => [
                'statusCode' => $response->getStatusCode(),
                'body' => $response->getBody()->getContents(),
            ]
        ]);
        throw new RuntimeException("Unexpected error on $method. ctx=$ctx");
    }
}
