<?php

namespace Magento\SaaSOrderSync\Core\Merchant;

use Exception;
use Magento\Framework\Webapi\Exception as WebapiException;
use Magento\SaaSOrderSync\Api\Merchant\GetMerchantDataSummaryResponseInterface;
use Magento\SaaSOrderSync\Api\Merchant\MerchantManagerInterface;
use Magento\SaaSOrderSync\Core\SaaS\SaaSClientResolverInterface;
use Psr\Log\LoggerInterface;

class MerchantManager implements MerchantManagerInterface
{
    private SaaSClientResolverInterface $clientResolver;
    private LoggerInterface $logger;

    public function __construct(SaaSClientResolverInterface $clientResolver, LoggerInterface $logger)
    {
        $this->clientResolver = $clientResolver;
        $this->logger = $logger;
    }


    public function getMerchantDataSummary(): GetMerchantDataSummaryResponseInterface
    {
        try {
            $merchantClient = $this->clientResolver->createMerchantClient();
            ['orders' => $orderSummary] = $merchantClient->getDataSummary();

            return new GetMerchantDataSummaryResponse(new MerchantDataSummaryOrders(
                createdFrom: $orderSummary['createdFrom'] ?? "",
                createdTo: $orderSummary['createdTo'] ?? "",
                totalCount: $orderSummary['totalCount'] ?? 0,
                syncErrorsCount: $orderSummary['syncErrorsCount'] ?? 0)
            );
        } catch (Exception $e) {
            $this->logger->critical("Unexpected error on " . (__METHOD__) . ".", ['exception' => $e]);
            throw new WebapiException(
                __("Unexpected error. Please try again later."),
                httpCode: WebapiException::HTTP_INTERNAL_ERROR
            );
        }
    }
}
