<?php

namespace Magento\SaaSOrderSync\Core\Merchant;

use Magento\SaaSOrderSync\Api\Merchant\MerchantDataSummaryOrdersInterface;

class MerchantDataSummaryOrders implements MerchantDataSummaryOrdersInterface
{

    private string $createdFrom;
    private string $createdTo;
    private int $totalCount;
    private int $syncErrorsCount;

    public function __construct(string $createdFrom, string $createdTo, int $totalCount, int $syncErrorsCount)
    {
        $this->createdFrom = $createdFrom;
        $this->createdTo = $createdTo;
        $this->totalCount = $totalCount;
        $this->syncErrorsCount = $syncErrorsCount;
    }


    /**
     * @inheritdoc
     */
    public function getCreatedFrom(): string
    {
        return $this->createdFrom;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedTo(): string
    {
        return $this->createdTo;
    }

    /**
     * @inheritdoc
     */
    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    /**
     * @inheritdoc
     */
    public function getSyncErrorsCount(): int
    {
        return $this->syncErrorsCount;
    }
}
