<?php

declare(strict_types=1);

namespace Magento\SaaSOrderSync\Api\OrderSync;

/**
 * SaaS order sync REST API.
 *
 * @api
 */
interface OrderSyncManagerInterface
{
    /**
     * POST create an order synchronization
     *
     * @param string $created_from initial created_at date to sync in ISO8601 format
     * @param string $client_code who created the sync
     * @param bool $optimize_time_range optimize or not the synchronization
     * @param bool $force forces the reprocessing of the order in the SaaS service
     * @return \Magento\SaaSOrderSync\Api\OrderSync\CreateOrderSyncResponseInterface the order synchronization result
     */
    public function createOrderSync(
        string $created_from,
        string $client_code,
        bool   $optimize_time_range = true,
        bool   $force = false,
    ): CreateOrderSyncResponseInterface;

    /**
     * GET all order synchronizations
     *
     * @return \Magento\SaaSOrderSync\Api\OrderSync\GetAllOrderSyncsResponseInterface the order synchronizations
     */
    public function getAllOrderSyncs(): GetAllOrderSyncsResponseInterface;

    /**
     * GET one order synchronization by its identifier
     *
     * @param string $sync_id synchronization id
     * @return \Magento\SaaSOrderSync\Api\OrderSync\GetOneOrderSyncResponseInterface the order synchronization
     */
    public function getOneOrderSync(string $sync_id): GetOneOrderSyncResponseInterface;

    /**
     * PUT cancel an order synchronization
     *
     * @param string $sync_id synchronization id
     * @return \Magento\SaaSOrderSync\Api\OrderSync\CancelOrderSyncResponseInterface the cancellation result
     */
    public function cancelOrderSync(string $sync_id): CancelOrderSyncResponseInterface;
}
