<?php

namespace Magento\SaaSOrderSync\Core\OrderSync;

use DateTime;
use DateTimeInterface;
use Magento\Framework\App\ResourceConnection;

class LocalOrderSyncRepository
{
    const TABLE_NAME = 'saas_order_sync';

    private ResourceConnection $resourceConnection;

    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    public function find(string $syncId): ?LocalOrderSync
    {
        $tableName = $this->resourceConnection->getTableName(self::TABLE_NAME);
        $connection = $this->resourceConnection->getConnection();

        $select = $connection->select()
            ->from($tableName)
            ->where('sync_id = ?', $syncId);

        $row = $connection->fetchRow($select);
        if ($row && $row['sync_id']) {
            $canceledAt = null;
            if ($row['canceled_at']) {
                $canceledAt = new DateTime($row['canceled_at']);
            }
            return new LocalOrderSync($row['sync_id'], $canceledAt);
        }

        return null;
    }

    public function upsert(string $syncId, DateTime $canceledAt): int
    {
        $tableName = $this->resourceConnection->getTableName(self::TABLE_NAME);
        $connection = $this->resourceConnection->getConnection();

        return $connection->insertOnDuplicate(
            $tableName,
            ['sync_id' => $syncId, 'canceled_at' => $canceledAt->format(DateTimeInterface::ATOM)],
            ['canceled_at']
        );
    }
}
