<?php

namespace Magento\SaaSOrderSync\Test\Unit\Core\OrderSync;

use Magento\AsynchronousOperations\Api\Data\OperationInterface;
use Magento\SaaSOrderSync\Core\OrderSync\OrdersBulkCancelationPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\OrdersBulkCompletionPlugin;
use Magento\SaaSOrderSync\Core\OrderSync\OrdersBulkConsumer;

/**
 * Runner for running OrdersBulkConsumer and its plugins.
 *
 * @see https://developer.adobe.com/commerce/php/development/components/plugins/#prioritizing-plugins
 */
class OrdersBulkConsumerWithPluginsRunner
{
    private OrdersBulkConsumer $consumer;
    private OrdersBulkCancelationPlugin $cancelationPlugin;
    private OrdersBulkCompletionPlugin $completionPlugin;

    public function __construct(
        OrdersBulkConsumer          $consumer,
        OrdersBulkCancelationPlugin $cancelationPlugin,
        OrdersBulkCompletionPlugin  $completionPlugin
    ) {
        $this->consumer = $consumer;
        $this->cancelationPlugin = $cancelationPlugin;
        $this->completionPlugin = $completionPlugin;
    }

    public function consume(OperationInterface $operation): bool
    {
        $wrappedConsume = function ($op) {
            $result =  $this->consumer->consume($op);
            return  $this->completionPlugin->afterConsume($this->consumer, $result, $op);
        };

        return $this->cancelationPlugin->aroundConsume($this->consumer, $wrappedConsume, $operation);
    }
}
