# Sync orders with SaaS

Provides APIs for synchronizing orders into SaaS.

Before installing the
package, [Message Queue Framework](https://developer.adobe.com/commerce/php/development/components/message-queues/)
has to be configured since it is used to synchronize the orders in the background.

## Installation in Magento Cloud

1. Configuration of Magento Queue Framework:
    1. Provision Rabbitmq according
       to [this guide](https://experienceleague.adobe.com/docs/commerce-cloud-service/user-guide/configure/service/rabbitmq.html?lang=en).
    2. Enable message queues consumers by cron job in `.magento.env.yaml` using `CRON_CONSUMERS_RUNNER` environment
       variable.
       ```yaml
       stage:
         deploy:
           CRON_CONSUMERS_RUNNER:
             cron_run: true
       ```
       See all the available configuration options
       in [the official documentation](https://experienceleague.adobe.com/docs/commerce-cloud-service/user-guide/configure/env/stage/variables-deploy.html?lang=en#cron_consumers_runner).
2. Install the package
   ```shell
   composer require magento/module-saas-order-sync
   ```

## Usage

In order to manage order synchronizations the following APIs are available:

### Start order sync

Triggers order synchronizations.

#### Rest

See https://magento.test/swagger#/saaSOrderSyncOrderSyncOrderSyncManagerV1/PostV1SaasOrderSyncOrderSync

#### Cli

```shell
$ bin/magento saas:order-sync:start --help 
Description:
  Synchronize orders with the SaaS from a certain point in time.

Usage:
  saas:order-sync:start [options] [--] <from>

Arguments:
  from                                             From date time in ISO-8601 format.

Options:
  -o, --optimize-time-range[=OPTIMIZE-TIME-RANGE]  Optimize requested time range by inspecting the merchant data summary (true|false). [default: "true"]
  -h, --help                                       Display this help message
  -q, --quiet                                      Do not output any message
  -V, --version                                    Display this application version
      --ansi                                       Force ANSI output
      --no-ansi                                    Disable ANSI output
  -n, --no-interaction                             Do not ask any interactive question
  -v|vv|vvv, --verbose                             Increase the verbosity of messages: 1 for normal output, 2 for more verbose output and 3 for debug
```

### Get order sync status

Get the status of a SaaS order synchronization.

#### Rest

See:

* https://magento.test/swagger#/saaSOrderSyncOrderSyncOrderSyncManagerV1/GetV1SaasOrderSyncOrderSync
* https://magento.test/swagger#/saaSOrderSyncOrderSyncOrderSyncManagerV1/GetV1SaasOrderSyncOrderSyncSync_id

#### Cli

```shell
$ bin/magento saas:order-sync:status --help 
Description:
  Get the status of a SaaS order synchronization.

Usage:
  saas:order-sync:status [options] [--] <syncId>

Arguments:
  syncId                  Sync id

Options:
  -b, --show-bulk-detail  Show detail of the bulk.
  -h, --help              Display this help message
  -q, --quiet             Do not output any message
  -V, --version           Display this application version
      --ansi              Force ANSI output
      --no-ansi           Disable ANSI output
  -n, --no-interaction    Do not ask any interactive question
  -v|vv|vvv, --verbose    Increase the verbosity of messages: 1 for normal output, 2 for more verbose output and 3 for debug
```

### Cancel order sync

#### Rest

See https://magento.test/swagger#/saaSOrderSyncOrderSyncOrderSyncManagerV1/PutV1SaasOrderSyncOrderSyncSync_idCancel

#### Cli

```shell
$ bin/magento saas:order-sync:cancel --help
Description:
  Cancel a SaaS order synchronization.

Usage:
  saas:order-sync:cancel <syncId>

Arguments:
  syncId                Sync id

Options:
  -h, --help            Display this help message
  -q, --quiet           Do not output any message
  -V, --version         Display this application version
      --ansi            Force ANSI output
      --no-ansi         Disable ANSI output
  -n, --no-interaction  Do not ask any interactive question
  -v|vv|vvv, --verbose  Increase the verbosity of messages: 1 for normal output, 2 for more verbose output and 3 for debug
```

### Merchant data summary

Get merchant data summary loaded in SaaS

#### Rest

See: https://magento.test/swagger#/saaSOrderSyncMerchantMerchantManagerV1/GetV1SaasOrderSyncMerchantDataSummary
