<?php

namespace Magento\SaaSOrderSync\Core\OrderSync;

use Magento\Framework\Lock\LockManagerInterface;
use Psr\Log\LoggerInterface;

class OrderSyncLock
{
    private LoggerInterface $logger;
    private LockManagerInterface $lockManager;

    public function __construct(LoggerInterface $logger, LockManagerInterface $lockManager)
    {
        $this->logger = $logger;
        $this->lockManager = $lockManager;
    }

    public function locking(string $syncId, callable $callable)
    {
        $lockName = "orders-sync-$syncId";
        $ctx = ['syncId' => $syncId];

        try {
            if (!$this->lockManager->lock($lockName)) {
                $this->logger->error("Cannot lock '$lockName' for order sync.", $ctx);
            }

            return $callable($syncId);
        } finally {
            if (!$this->lockManager->unlock($lockName)) {
                $this->logger->error("Cannot unlock $lockName order sync.", $ctx);
            }
        }
    }
}
