<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Event;

use Magento\AdobeCommerceEventsClient\Event\Metadata\EventMetadataInterface;
use Magento\SaaSCustomerSync\Support\Logging;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 * Collects metadata related to Adobe Commerce Scope
 */
class ScopeMetadataCollector implements EventMetadataInterface
{

    /**
     * @param StoreManagerInterface $storeManager
     * @param LoggerInterface $logger
     */
    public function __construct(
        private readonly StoreManagerInterface $storeManager,
        private readonly LoggerInterface       $logger,
    ) {
    }

    /**
     * Returns metadata related to the current scope
     *
     * @return array of metadata
     */
    public function get(): array
    {
        $metadata = [];
        try {
            $metadata['websiteCode'] = $this->storeManager->getWebsite()->getCode();
            $metadata['storeCode'] = $this->storeManager->getStore()->getCode();
            $metadata['storeViewCode'] = $this->storeManager->getGroup()->getCode();
        } catch (Throwable $e) {
            $this->logger->error("Can't collect scope metadata.", ['exception' => Logging::formatException($e)]);
        }

        return $metadata;
    }
}
