<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Test\Unit\Support;

use PHPUnit\Framework\TestCase;
use Magento\SaaSCustomerSync\Support\Arrays;

class ArraysTest extends TestCase
{
    public function testNestArray_shouldMapEmptyArrayToEmptyArray(): void
    {
        $result = Arrays::nestArray([]);

        $this->assertEquals([], $result);
    }

    public function testNestArray_shouldNestMultipleLevels(): void
    {
        $input = [
            "user.first_name" => "John",
            "user.last_name" => "Doe",
            "user.career.name" => "Programmer",
            "user.career.description" => "Develops stuff",
        ];

        $expectedOutput = [
            "user" => [
                "first_name" => "John",
                "last_name" => "Doe",
                "career" => [
                    "name" => "Programmer",
                    "description" => "Develops stuff",
                ],
            ]
        ];

        $actualOutput = Arrays::nestArray($input);

        $this->assertEquals($expectedOutput, $actualOutput);
    }

    public function testNestArray_shouldNestFalseyValues(): void
    {
        $input = [
            "user.first_name" => null,
            "user.last_name" => false,
            "user.career.name" => 0,
            "user.career.description" => "",
        ];

        $expectedOutput = [
            "user" => [
                "first_name" => null,
                "last_name" => false,
                "career" => [
                    "name" => 0,
                    "description" => "",
                ],
            ]
        ];

        $actualOutput = Arrays::nestArray($input);

        $this->assertEquals($expectedOutput, $actualOutput);
    }

    public function testSetNested_shouldSetNestedValueMultipleLevelsDeep(): void
    {
        $arrayToMutate = [];

        $expectedResult = [
            "foo" => [
                "bar" => [
                    "A" => "Amsterdam",
                    "B" => "Barcelona",
                ]
            ]
        ];

        Arrays::setNested($arrayToMutate, "foo.bar.A", "Amsterdam");
        Arrays::setNested($arrayToMutate, "foo.bar.B", "Barcelona");

        $this->assertEquals($arrayToMutate, $expectedResult);
    }

    public function testAllNull_shouldReturnTrueForEmptyArray(): void
    {
        $result = Arrays::allNull([]);

        $this->assertTrue($result);
    }

    public function testAllNull_shouldReturnTrueForArrayContainingOnlyNullValues(): void
    {
        $input = [null, null, null];

        $result = Arrays::allNull($input);

        $this->assertTrue($result);
    }

    public function testAllNull_shouldReturnFalseForArrayContainingNonNullValue(): void
    {
        $input = [null, null, null, 0, null];

        $result = Arrays::allNull($input);

        $this->assertFalse($result);
    }
}
