<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
namespace Magento\SaaSCustomerSync\Test\Unit\Model;

use Magento\Framework\DataObject\IdentityGeneratorInterface;

/**
 * @SuppressWarnings(PHPMD.UnusedFormalParameter)
 */
class FixedIdentityGenerator implements IdentityGeneratorInterface
{
    private string $id;

    public function __construct(string $id = null)
    {
        $this->setId($id ?: uniqid());
    }

    public function generateId(): string
    {
        return $this->id;
    }

    public function generateIdForData($data): string
    {
        return $this->id;
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function setId($id): void
    {
        $this->id = $id;
    }
}
