<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Support;

class Logging {

    /**
     * Formats an exception as a string with minimal information to avoid exposing potential PII.
     *
     *  "Exception occurred: [object] (UnexpectedValueException(code: 0) at
     *      /var/www/html/ext/extensions/customers-connector/SaaSCustomerSync/Model/OperationConsumer.php:58"
     *
     * @param \Exception $e
     * @return string
     */
    public static function formatException(\Exception $e): string {
        return sprintf(
            'Exception occurred: [object] (%s(code: %s) at %s:%s)',
            get_class($e),
            $e->getCode(),
            $e->getFile(),
            $e->getLine(),
        );
    }

}
