# Development

## Start bulk consumer
```shell
bin/magento queue:consumers:start saas.customer.sync.bulk.consumer
```

## Run unit tests
```shell
bin/dev-test-run unit ../../../ext/extensions/customers-connector
```

## Useful database queries

### Query sync's bulk
```sql
SELECT * 
FROM magento_bulk
WHERE uuid='syncId'
```

### Query sync's bulk operations
```sql
SELECT *
FROM magento_operation 
WHERE bulk_uuid='syncId'
ORDER BY started_at ASC
```

## Code style

### Logging exceptions

We format exceptions using `Magento\SaaSOrderSync\Support\Logging::formatException` before sending them as context
variable to the logger to avoid exposing PII.

> [!NOTE]  
> Kodiak may still flag a logged exception formatted with `formatException` as an 'Information Exposure in PHP' issue.
> As long as the log is only for troubleshooting and nothing else, we can silence these warnings by marking them as
> false positives in Kodiak.
