<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Api;

use Magento\SaaSCustomerSync\Api\Data\CreateCustomerSyncResponseInterface;
use Magento\SaaSCustomerSync\Api\Data\GetCustomerSyncResponseInterface;

/**
 * SaaS customer sync operations.
 *
 * @api
 */
interface CustomerSyncManagerInterface
{
    /**
     * POST create a customers synchronization
     *
     * @param string $created_from initial created_at date to sync in ISO8601 format
     * @param string $created_to final created_at date to sync in ISO8601 format
     * @return \Magento\SaaSCustomerSync\Api\Data\CreateCustomerSyncResponseInterface the customer synchronization response
     */
    public function createCustomerSync(
        string $created_from,
        string $created_to,
    ): CreateCustomerSyncResponseInterface;

    /**
     * GET a customer synchronization by its identifier
     *
     * @param string $sync_id synchronization id
     * @return \Magento\SaaSCustomerSync\Api\Data\GetCustomerSyncResponseInterface the customer synchronization
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getCustomerSync(string $sync_id): GetCustomerSyncResponseInterface;
}
