<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Model\Data;

use Magento\SaaSCustomerSync\Api\Data\CreateCustomerSyncResponseInterface;

class CreateCustomerSyncResponse implements CreateCustomerSyncResponseInterface
{
    private string $syncId;
    private string $createdFrom;
    private string $createdTo;
    private int $customerCount;

    public function __construct(string $syncId, string $createdFrom, string $createdTo, int $customerCount)
    {
        $this->syncId = $syncId;
        $this->createdFrom = $createdFrom;
        $this->createdTo = $createdTo;
        $this->customerCount = $customerCount;
    }

    /**
     * @inheritdoc
     */
    public function getSyncId(): string
    {
        return $this->syncId;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedFrom(): string
    {
        return $this->createdFrom;
    }

    /**
     * @inheritdoc
     */
    public function getCreatedTo(): string
    {
        return $this->createdTo;
    }

    /**
     * @inheritdoc
     */
    public function getCustomerCount(): int
    {
        return $this->customerCount;
    }
}
