<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCustomerSync\Test\Unit\Event;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\SaaSCustomerSync\Event\ScopeMetadataCollector;
use Magento\Store\Api\Data\GroupInterface;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Api\Data\WebsiteInterface;
use Magento\Store\Model\StoreManagerInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Psr\Log\NullLogger;
use function PHPUnit\Framework\assertEquals;
use function PHPUnit\Framework\assertEqualsCanonicalizing;
use function PHPUnit\Framework\once;

class ScopeMetadataCollectorTest extends TestCase
{

    /**
     * @var StoreManagerInterface&MockObject
     */
    private StoreManagerInterface&MockObject $storeManagerMock;

    /**
     * @var ScopeMetadataCollector
     */
    private ScopeMetadataCollector $scopeMetadataCollector;

    public function setUp(): void
    {
        $this->storeManagerMock = $this->createMock(StoreManagerInterface::class);
        $this->scopeMetadataCollector = new ScopeMetadataCollector($this->storeManagerMock, new NullLogger());
    }

    public function testShouldReturnScopeMetadata(): void
    {
        $this->storeManagerMock->expects(once())
            ->method('getWebsite')
            ->willReturn($this->websiteMock('foo'));

        $this->storeManagerMock->expects(once())
            ->method('getStore')
            ->willReturn($this->storeMock('bar'));

        $this->storeManagerMock->expects(once())
            ->method('getGroup')
            ->willReturn($this->storeGroupMock('baz'));

        $metadata = $this->scopeMetadataCollector->get();

        assertEqualsCanonicalizing($metadata, [
            'websiteCode' => 'foo',
            'storeCode' => 'bar',
            'storeViewCode' => 'baz',
        ]);
    }

    public function testShouldNotReturnMetadataWhenFailure(): void
    {
        $this->storeManagerMock->expects(once())
            ->method('getWebsite')
            ->willThrowException(new NoSuchEntityException());

        $metadata = $this->scopeMetadataCollector->get();

        assertEquals([], $metadata);
    }

    private function websiteMock(string $websiteCode): WebsiteInterface&MockObject
    {
        $mock = $this->createMock(WebsiteInterface::class);
        $mock->method('getCode')->willReturn($websiteCode);
        return $mock;
    }

    private function storeMock(string $storeCode): StoreInterface&MockObject
    {
        $mock = $this->createMock(StoreInterface::class);
        $mock->method('getCode')->willReturn($storeCode);
        return $mock;
    }

    private function storeGroupMock(string $storeGroupCode): GroupInterface&MockObject
    {
        $mock = $this->createMock(GroupInterface::class);
        $mock->method('getCode')->willReturn($storeGroupCode);
        return $mock;
    }
}
