<?php
/*************************************************************************
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ***********************************************************************
 */
declare(strict_types=1);

namespace Magento\SaaSCommon\Model;

use Magento\Framework\Lock\LockManagerInterface;

class FeedLockManager
{
    private const LOCK_PREFIX = 'feed_sync_';

    /**
     * @var LockManagerInterface
     */
    private LockManagerInterface $lockManager;

    /**
     * @param LockManagerInterface $lockManager
     */
    public function __construct(
        LockManagerInterface $lockManager
    ) {
        $this->lockManager = $lockManager;
    }

    /**
     * Set feed sync lock.
     *
     * @param string $feedName
     * @return bool
     */
    public function lock(string $feedName): bool
    {
        return $this->lockManager->lock(self::LOCK_PREFIX . $feedName, 0);
    }

    /**
     * Remove feed sync lock.
     *
     * @param string $feedName
     * @return bool
     */
    public function unlock(string $feedName): bool
    {
        return $this->lockManager->unlock(self::LOCK_PREFIX . $feedName);
    }
}
