<?php
/**
 * Copyright 2014 Adobe
 * All Rights Reserved.
 */
namespace Magento\Reports\Controller\Adminhtml\Report\Product;

use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;

class Lowstock extends \Magento\Reports\Controller\Adminhtml\Report\Product implements HttpGetActionInterface
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Magento_Reports::lowstock';

    /**
     * Low stock action
     *
     * @return void
     */
    public function execute()
    {
        $this->_initAction()->_setActiveMenu(
            'Magento_Reports::report_products_lowstock'
        )->_addBreadcrumb(
            __('Low Stock'),
            __('Low Stock')
        );
        $this->_view->getPage()->getConfig()->getTitle()->prepend(__('Low Stock Report'));
        $this->_view->renderLayout();
    }
}
