/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define(['jquery'], function ($) {
    'use strict';

    var locale = window.checkoutConfig.payment['quick_checkout'].locale,
        publishableKey = window.checkoutConfig.payment['quick_checkout'].publishableKey,
        config = {
            language: locale,
            style: {
                position: 'right'
            }
        },
        boltEmbedded = window.Bolt(publishableKey),
        authorizationComponent = boltEmbedded.create('authorization_component', config);

    return function (selector) {
        var mountCompleted = $.Deferred();

        authorizationComponent.unmount();
        authorizationComponent.mount(selector).then(function () {
            mountCompleted.resolve(authorizationComponent);
        });
        return mountCompleted;
    };
});
