/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'jquery',
    'Magento_QuickCheckout/js/model/authorization',
    'Magento_QuickCheckout/js/action/otp-login'
], function ($, authorization, otpLogin) {
    'use strict';

    return function (email, selector) {
        var fieldSelector = selector || '#customer-email-fieldset',
            authorizationCode = '',
            authorizationResult = null;

        if ($(fieldSelector).is(':visible') === false) {
            return;
        }

        authorizationResult = authorization(fieldSelector);

        $.when(authorizationResult).done(function (component) {
            component.authorize({ email: email }).then(function (data) {
                component.unmount();
                if (typeof data !== 'undefined') {
                    authorizationCode = data.authorizationCode;
                    otpLogin(authorizationCode);
                }
            });
        });
    };
});
