/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/* eslint-disable max-nested-callbacks */
define([
        'jquery',
        'Magento_QuickCheckout/js/model/customer/customer',
        'Magento_QuickCheckout/js/model/authorization',
        'Magento_QuickCheckout/js/action/otp-refresh'
    ], function (
        $,
        boltCustomer,
        authorization,
        otpRefresh
    ) {
        'use strict';

        return function (selector) {
            var authResult = authorization(selector),
                authorizationCode = '',
                customerEmail = boltCustomer.getEmail(),
                reAuthResult = $.Deferred();

            $.when(authResult).done(function (component) {
                component.authorize({email: customerEmail}).then(function (authorizeResult) {
                    component.unmount();
                    if (typeof authorizeResult === 'undefined') {
                        reAuthResult.resolve(false);
                        return;
                    }
                    authorizationCode = authorizeResult.authorizationCode;
                    $.when(otpRefresh(authorizationCode)).done(function (refreshResult) {
                        reAuthResult.resolve(refreshResult);
                    });
                });
            });
            return reAuthResult;
        };
    }
);
