/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'jquery',
    'ko',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_QuickCheckout/js/action/check-existing-account',
    'Magento_QuickCheckout/js/model/account-handling',
    'Magento_QuickCheckout/js/model/customer/customer',
    'Magento_Customer/js/model/customer',
    'Magento_QuickCheckout/js/model/event-tracking'
], function (
    $,
    ko,
    quote,
    checkoutData,
    boltAccountDataAction,
    bolt,
    boltCustomer,
    customer,
    eventTracking
) {
    'use strict';

    return function (Email) {
        return Email.extend({

            /**
             * @override
             */
            isCustomerLoggedIn: ko.observable(customer.isLoggedIn() || boltCustomer.isBoltUser()),

            /**
             * Initializes observable properties of instance
             *
             * @returns {Object} Chainable.
             */
            initObservable: function () {
                var self = this;

                this._super();
                boltCustomer.isBoltUser.subscribe(function () {
                    self.isCustomerLoggedIn(customer.isLoggedIn() || boltCustomer.isBoltUser());
                });
                return this;
            },

            /**
             * Callback on changing email property
             */
            emailHasChanged: function () {
                this._super();
                this.isCustomerLoggedIn(customer.isLoggedIn() || boltCustomer.isBoltUser());
            },

            /**
             * @override
             * Check email existing
             */
            checkEmailAvailability: function () {
                this._super();
                eventTracking.sendDetailEntryBeganEvent();
                if (bolt.canDisplayOtpPopup() && !bolt.isBoltUser()) {
                    $.when(this.isEmailCheckComplete).always(function () {
                        this.checkBoltAccountExists();
                    }.bind(this));
                }
            },

            /**
             * Check subscription status
             */
            checkBoltAccountExists: function () {
                if (quote.guestEmail) {
                    boltAccountDataAction(quote.guestEmail, this.isPasswordVisible());
                    checkoutData.setLoggedOut(false);
                }
            }
        });
    };
});
