/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'jquery',
    'Magento_QuickCheckout/js/action/otp-login'
], function ($, otpLogin) {
    'use strict';

    return function (email, selector) {
        var locale = window.checkoutConfig.payment['quick_checkout'].locale,
            boltEmbedded = window.Bolt(
                window.checkoutConfig.payment['quick_checkout'].publishableKey
            ),
            authorizationComponent = boltEmbedded.create(
                'authorization_component',
                {
                    language: locale,
                    style: {
                        position: 'right'
                    }
                }
            ),
            customerEmailFieldsetSelector = selector || '#customer-email-fieldset',
            authorizationCode = '';

        if ($(customerEmailFieldsetSelector).is(':visible') === false) {
            return;
        }

        authorizationComponent
            .mount(customerEmailFieldsetSelector)
            .then(function () {
                authorizationComponent
                    .authorize({ email: email })
                    .then(function (data) {
                        authorizationComponent.unmount();
                        if (typeof data !== 'undefined') {
                            authorizationCode = data.authorizationCode;
                            otpLogin(authorizationCode);
                        }
                    });
            });
    };
});
