/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
        'mage/translate',
        'mage/storage',
        'Magento_Checkout/js/model/full-screen-loader',
        'Magento_Ui/js/model/messageList',
        'Magento_Customer/js/customer-data',
        'Magento_QuickCheckout/js/action/get-account-details'
    ], function (
        $t,
        storage,
        fullScreenLoader,
        globalMessageList,
        customerData,
        getAccountDetails
    ) {
        'use strict';

        return function (code) {
            var payload = {code: code},
                defaultError = $t('Could not authenticate. Please try again later.');

            fullScreenLoader.startLoader();

            return storage.post(
                'quick-checkout/ajax/login',
                JSON.stringify(payload),
                false
            ).done(function (response) {
                if (!response.success) {
                    globalMessageList.addErrorMessage({'message': response.message});
                    return;
                }

                if (!response.isLoggedInBothNetworks) {
                    getAccountDetails();
                    return;
                }

                customerData.invalidate(['customer']);
                window.location.reload();
            }).fail(function () {
                globalMessageList.addErrorMessage({'message': defaultError});
            }).always(function () {
                fullScreenLoader.stopLoader();
            });
        };
    }
);
